  

---

#### 1. **Threats from Malicious Routing Information**

- Attackers can use malicious routing updates to:
    - Redirect or delete sensitive traffic.
    - Violate confidentiality and integrity.
    - Enable denial-of-service (DoS) attacks.

---

#### 2. **Mitigating Denial-of-Service (DoS) Routing Attacks**

- **Data Plane ACLs**
    - Use fast-path data plane ACLs to restrict which hosts can send routing protocol information.
    - Can be challenging to scale if there are many interfaces or discontiguous IP addresses.
- **CoPP and CPPr**
    - Locally restrict routing protocol peers by IP address.
- **Routing Protocol Authentication**
    - Embed cryptographic integrity and authenticity proofs in routing protocol messages.
    - Prevent spoofing of routing adjacencies and updates.
- **Routing Protocol Filtering**
    - Filter out malicious routing information, even from known peers.

---

#### 3. **Routing Protocol Authentication**

- **Purpose:**
    
    - Restricts protocol participation to trusted peers.
    - Blocks unauthorized/fake routing updates.
    - Does not protect if a trusted device is compromised.
- **Authentication Methods:**
    
    - Cleartext passwords (less secure).
    - HMAC-MD5 and HMAC-SHA algorithms (preferred for security).
        - Use a shared secret to generate a hash with each update.
        - Hash functions are one-way, making it difficult to recover the original secret.
        - Risk increases if shared secrets are not changed regularly.
- **Authentication Feature Availability:**
    
    |Feature|Platform|
    |---|---|
    |RIPv2 MD5 authentication|Cisco IOS XE, Cisco Secure Firewall Threat Defense, Cisco Secure Firewall ASA|
    |OSPF MD5 authentication|Cisco IOS XE, Cisco Secure Firewall Threat Defense, Cisco Secure Firewall ASA|
    |OSPF SHA authentication|Cisco IOS XE (using key chain)|
    |BGP MD5 authentication|Cisco IOS XE, Cisco Secure Firewall Threat Defense, Cisco Secure Firewall ASA|
    |EIGRP MD5 authentication|Cisco IOS XE, Cisco Secure Firewall Threat Defense, Cisco Secure Firewall ASA|
    |EIGRP SHA authentication|Cisco IOS XE (using EIGRP named configuration)|
    |HSRP MD5 authentication|Cisco IOS XE|
    
- **Implementation Guidelines:**
    
    - Always use authentication when routing protocols run over untrusted or shared segments.
    - Prefer HMAC-SHA > HMAC-MD5 > cleartext.
    - Use strong, unique secrets for each group or area.
    - Avoid using the same secret across all devices.
    - Use key rollover (key chains) if available.

---

#### 4. **Routing Protocol Filtering**

- **Purpose:**
    
    - Controls the routing information exchanged with known peers, trusted or untrusted.
    - Allows only trusted information into or out of the routing domain.
    - Can drop known malicious or unauthorized routes.

- **Filtering Feature Availability:**
    
    |Feature|Platform|
    |---|---|
    |RIPv2 distribution lists|Cisco IOS XE, Cisco Secure Firewall Threat Defense, Cisco Secure Firewall ASA|
    |OSPF ABR filtering|Cisco IOS XE, Cisco Secure Firewall Threat Defense, Cisco Secure Firewall ASA|
    |BGP filtering|Cisco IOS XE, Cisco Secure Firewall Threat Defense, Cisco Secure Firewall ASA|
    |EIGRP distribution lists|Cisco IOS XE, Cisco Secure Firewall Threat Defense, Cisco Secure Firewall ASA|
    
- **Filtering Mechanisms:**
    
    - Distribution lists
    - Prefix lists
    - Community lists
    - Redistribution with filtering

---

#### 5. **Deployment Guidelines for Routing Protocol Filtering**

- Use BGP for connections to external domains; it offers comprehensive filtering and conservative advertisement of routes.
- Internally, use built-in filtering features of IGPs (e.g., OSPF, EIGRP); consider BGP for large networks requiring tight control.
- Use redistribution between routing processes for additional filtering flexibility.
- At the intersection of security zones, run two routing processes:
    - Trusted routing process (trusted domain/segment).
    - Untrusted routing process (for less trusted peers).

---

#### 6. **Best Practices and Considerations**

- Authenticate and filter routing protocols over untrusted or public networks.
- Prefer strong cryptographic algorithms and unique, strong secrets.
- Regularly update keys and use key rollover where supported.
- Filter routing information at domain boundaries to prevent leaks or attacks from less trusted peers.